/**
 * Created by lei.wang_1 on 2016.
 */
appModule.service('utils', ['native', '$q','$translate','$rootScope', function (native, $q, translate,$rootScope) {
    var NOTICE_USER = "notice_user";
    var cursorLeft, cursorTop, position;
    $rootScope.isMacOS = parseInt(localStorage['osType']) == 1;
    function intwidth(h) {
        if (h < 10) {
            h = '0' + h;
        }
        return h;
    }

    return {
        time2str: function (timeLng, onlyMS) {
            // var DT = new Date();
            // if (timeLng !== undefined) {
            //     timeLng = parseInt(timeLng);
            //     var SERVER_TIME_ZONE = -8 * 60;
            //     var local_time_zone = DT.getTimezoneOffset();
            //     timeLng = timeLng + ((local_time_zone - SERVER_TIME_ZONE) * 60);
            //     DT.setTime(timeLng * 1000);
            // }
            var DT = new Date(timeLng * 1000);
            var y = DT.getYear(); //获取当前年份(2位)
            var Y = DT.getFullYear(); //获取完整的年份(4位,1970-????)
            var m = DT.getMonth() + 1; //获取当前月份(0-11,0代表1月)
            var d = DT.getDate(); //获取当前日(1-31)
            //myDate.getDay();         //获取当前星期X(0-6,0代表星期天)
            //myDate.getTime();        //获取当前时间(从1970.1.1开始的毫秒数)
            var h = DT.getHours(); //获取当前小时数(0-23)
            var i = DT.getMinutes(); //获取当前分钟数(0-59)
            var s = DT.getSeconds(); //获取当前秒数(0-59)
            //myDate.getMilliseconds();    //获取当前毫秒数(0-999)
            //myDate.toLocaleDateString();     //获取当前日期
            m = intwidth(m);
            d = intwidth(d);
            h = intwidth(h);
            i = intwidth(i);
            s = intwidth(s);

            DT = new Date();
            var Y0 = DT.getFullYear();
            var m0 = DT.getMonth() + 1;
            var d0 = DT.getDate();

            if(onlyMS){
                return i + ':' + s;
            }
            if (Y0 == Y) {
                if (m == m0 && d == d0) {
                    return h + ':' + i;
                } else {
                    return m + '/' + d + ' ' + h + ':' + i;
                }
            } else {
                return Y + '/' + m + '/' + d + ' ' + h + ':' + i;
            }
        },
        applyScope: function ($scope, func) {//预防angularjs 报 $apply already in progress 错误
            if ($scope.$$phase || $scope.$root && $scope.$root.$$phase) {
                func();
            } else {
                $scope.$apply(function () {
                    func();
                });
            }
        },
        getObjFromlocalStorage: function (key) {//获取本地数据
            if (!localStorage[key]) {
                return null;
            }
            return JSON.parse(localStorage[key]);
        },
        saveObjTolocalStorage: function (key, value) {//将数据存储到本地
            localStorage[key] = JSON.stringify(value);
        },
        removeObjFromlocalStorage: function (key) { //删除存储数据
            localStorage.removeItem(key);
        },
        retrieveUser: function () {//从session storage 获取user
            return this.getObjFromlocalStorage(NOTICE_USER);
        },
        setInputEditorCaretPosition: function (inputNode) {
            if (isNaN(cursorLeft) || isNaN(cursorTop)) {
                cursorLeft = inputNode.offset().left + 5;
                cursorTop = inputNode.offset().top + 10;
            }
            native.setCaretPosition(cursorLeft + 10, cursorTop + 8);
        },
        onInputCaretPositionKeyUp: function (inputNode) {
            position = inputNode.caret('position');
            cursorTop = inputNode.offset().top + position.top;
            cursorLeft = inputNode.offset().left + position.left;
        },
        uploadFile: function (path, callback) {
            native.ucFileUpload(path, callback);
        },
        openImageDialog: function (callback, maxSize, selectMore) {
            //var sizeLimit = !!maxSize ? maxSize : 5000000;
            var types = [{
                desc: translate.instant('common.image')+'(*.png; *.jpg; *.jpeg; *.gif)',
                filter: '*.png; *.jpg; *.jpeg; *.gif'
            }];
            var self = this;
            native.ucOpenFileDialog(translate.instant('common.open-image'), types, function (paths) {
                if (paths && paths.length > 0) {
                    for (var i = 0; i < paths.length; i++) {
                        var isValid = self._handleImage(paths[i]);

                        if(!isValid.error){
                            callback({errorCode:-1,msg:isValid.msg});
                            return;
                        }
                    }
                    callback({
                        errorCode: 0,
                        paths: paths
                    });
                }
            }, selectMore);
        },
        openFileDialog:function(callback,maxSize,selectedMore,filter){
            var sizeLimit = maxSize?maxSize:Number.MAX_SAFE_INTEGER;
            var filter = filter || '*.*';
            var types = [{
                desc: translate.instant('common.file')+'('+filter+')',
                filter: filter
            }];
            var that = this;
            native.ucOpenFileDialog(translate.instant('common.open-file'), types, function(paths){
                if (paths && paths.length > 0) {
                     var count = paths.length;
                     var uploadFiles = [];
                     for(var i =0; i<paths.length;i++){
                         var path = paths[i];
                         var obj = {
                             url:path,
                             size: that.getSizeText(that.getFileSize(path)),
                             name: that.getFileName(path)
                         };
                         getFileIcon(obj);
                         uploadFiles.push(obj);
                     }
                    
                     function getFileIcon(obj){
                        that.getFileIcon(obj.url,function(iconPath){
                            obj.icon = iconPath;
                            count --;
                            if(count  == 0){
                                callback({
                                    errorCode: 0,
                                    paths: paths,
                                    filesInfo:uploadFiles
                                });
                            }
                        });
                     }

                }
            }, selectedMore);
        },
        openAudioDialog:function(callback,selectedMore){
            var types = [{
                desc: translate.instant('common.audio')+'(*.mp3; *.amr; *.wav)',
                filter: '*.mp3; *.amr; *.wav'
            }];
            native.ucOpenFileDialog(translate.instant('common.open-audio'), types, function(paths){
                if (paths && paths.length > 0) {
                    callback({
                        errorCode: 0,
                        paths: paths
                    });
                }
            }, selectedMore);
        },
        getDropImages: function (callback, maxSize) {
            var sizeLimit = !!maxSize ? maxSize : 5000000;
            native.ucGetDropImages(callback, sizeLimit);
        },
        backToApp: function () {
            native.backToApp();
        },
        getFileSuffix: function (fileName) {
            if (!fileName || fileName.lastIndexOf('.') == -1) {
                return "";
            }

            return fileName.substr(fileName.lastIndexOf('.') + 1);
        },
        utf8ToBase64: function (str) {
            return window.btoa(encodeURIComponent(str));
        },
        uploadFiles: function (urls,uploadingCallback,uploadedCallback) {
            var deferred = $q.defer();
            if (urls && urls.length > 0) {
                native.uploadFiles(urls,deferred,uploadingCallback,uploadedCallback);
            } else {
                deferred.resolve();
            }
            return deferred.promise;
        },
        deleteFile: function (path) {
            native.deleteFile(path);
        },
        uploadOneFile: function (url,progressCallback) {
            var deferred = $q.defer(), taskId = null;
            native.bindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_UPLOADED_EVENT, function (e) {
                if (e.detail.taskId == taskId) {
                    if (e.detail.errorCode === 0) {
                        var data = e.detail;
                        var fileInfo = {
                            name: data.fileName,
                            size: data.fileSize,
                            url: data.downloadURL,
                            thumbnailURL: data.convertDownloadURL,
                            operatorId: data.operatorId,
                            operatorTime: data.operatorTime,
                            fid: data.fid
                        };
                        deferred.resolve({
                            code: 0,
                            data: fileInfo,
                            originalURL:url
                        });
                    } else {
                        deferred.resolve({
                            code: e.detail.errorCode
                        });
                    }
                    if(progressCallback){
                        native.unbindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_UPLOADING_EVENT, onProgress);
                    }
                    native.unbindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_UPLOADED_EVENT, arguments.callee);
                }
            });

            var onProgress = function(e){
                if(taskId == e.detail.taskId){
                    if (e.detail.errorCode === 0) {
                        progressCallback(url,e.detail.percent);
                    }
                }
            };
            
            if(progressCallback){
                native.bindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_UPLOADING_EVENT,onProgress);
            }
            
            native.ucFileUpload(url, function (result) {
                if (result[0] === 0) {
                    taskId = result[1];
                } else {
                    deferred.resolve({
                        code: result[0]
                    });
                }
            });

            return deferred.promise;
        },
        getFileSize: function (path) {
            return native.getFileSize(path);
        },
        getFileName:function(filePath){
            var index = filePath.lastIndexOf('\\');
            if (index == -1) {
                index = filePath.lastIndexOf('/');
            }
            return filePath.substr(index + 1);
        },
        getSizeText:function(size){
            if(size / (1024*1024) > 1){
                return (size / (1024 * 1024)).toFixed(2) + 'M';
            }else{
                return (size / 1024).toFixed(2) + 'K';
            }
        },
        isFileExist: function (path) {
            return native.fileExist(path);
        },
        getLocaleDateTime: function (d) {
            return d.getFullYear() + "/" + (d.getMonth() + 1) + "/" + d.getDate() + " " + d.getHours() + ":" + d.getMinutes();
        },
        convertMsgToHtml: function (message) {
            return native.convertMessageToHTML(message);
        },
        convertBadgeNumber: function (num) {
            if (num > 99) {
                return '99+';
            }
            return num;
        },
        parseCommentCopyData: function (data) {
            return native.parseCommentCopyData(data);
        },
        convertDomStrToMsg: function (html) {
            return native.convertDomStrToMsg(html);
        },
        getClipboardData: function () {
            return native.getClipboardData();
        },
        getUrlParam: function (url, name) {
            try{
                var reg = new RegExp("(^|&|\\?)" + name + "=([^&]*)(&|$)");
                var r = url.substr(1).match(reg);
                if (r != null) return decodeURIComponent(r[2]);
                return null;
            }catch(e){
               return null;
            }
        },
        getFileIcon:function(fileName,callback){
            native.getFileIcon(fileName,callback);
        },
        playMedia:function(url,processCallback,callback){
            native.playMedia(url,processCallback,callback);
        },
        stopPlayMedia:function(){
            native.stopPlayMedia();
        },
        openLocalMediaPlayer:function(url){
            native.openLocalMediaPlayer(url);
        },
        downloadFile:function(url,fileName){
            native.openSaveFileDialog(translate.instant('common.save-file'),fileName,translate.instant('common.all-files'),'',function(savePath){
                if(savePath){
                    native.downloadFile(url,savePath,function(path){
                        // native.openFile(path.slice(0,path.lastIndexOf('/')));
                    });
                }
            });
        },
        previewImage:function(urlList,url){
            native.openImagePreview(urlList,url);
        },
        getCurrentLanguage:function(){
           return native.getCurrentLanguage();
        },
        getPosition: function(element,e){
            var totalWidth = window.innerWidth, totalHeight = window.innerHeight;
            var left, top, elementWidth = element.width(),elementHeight = element.height();
            if(totalWidth < e.x+elementWidth){
                left = e.x - elementWidth;
            }else{
                left = e.x;
            }

            if(totalHeight < e.y + elementHeight){
                top = e.y - elementHeight;
            }else{
                top = e.y;
            }
            element.css({
                left:left,
                top:top
            })
        },
        convertImageToBase64:function(img,newWidth){
            var canvas = document.createElement("canvas");
            canvas.width = newWidth;
            canvas.height = img.height * newWidth/ img.width;
            var ctx = canvas.getContext("2d");
            ctx.drawImage(img, 0, 0, img.width, img.height,0,0,canvas.width,canvas.height);
            var dataURL = canvas.toDataURL("image/jpeg",0.7);
            return dataURL;
        },
        getVideoPoster:function(video){
            var canvas = document.createElement("canvas");
            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            var ctx = canvas.getContext("2d");
            ctx.drawImage(video, 0, 0);
            var dataURL = canvas.toDataURL("image/jpeg",0.2);
            return dataURL;
        },
        requestMainWindowMethod:function(classFullName,fnName,params,callback){
            native.requestNativeFn(classFullName,fnName,params,callback);
        },
        showUserProfile:function(userId){
            native.requestNativeFn('uc.IUIService','showPopupContactProfile',[userId])
        },
        removeMediaAttributes:function(content){
            return content.replace(/<(video)(.*)\/(video)>/g,'<$1></$1>').replace(/<(audio)(.*)\/(audio)>/g,'<$1></$1>');
        },
        _handleImage(imagePath){
            var illegal = false;
            var imageFormat = native.getImageFormat(imagePath);
            if(imageFormat == "gif"){
                var imageSize = native.getFileSize(imagePath);
                if(imageSize > 1000000){
                    illegal = true;
                    return {error:false,msg:translate.instant("image.ImageOverSize")};
                }
            }
            var imageObj = JSON.parse(native.getImageWidthHeight(imagePath));
            if((imageObj.width > 2000)||(imageObj.height > 2000)){
                return {error:false,msg:translate.instant("image.ResolutionTooBig")};
            }
            return {error:true};
        }
    };
}]);
